#include <cyg/hal/hal_arch.h> /* data types */
#ifndef CONFIG_H
#define CONFIG_H



/*
 * This is a header containing all static config options.
 * Put all #defines here!
 */

/*
 * TODO: Code anpassen
 */

// task priorities
#define SAMPLING_TASK_PRIORITY 0
#define TRIGGER_TASK_PRIORITY 0
#define ANALYSIS_TASK_PRIORITY 0
#define TIME_DOMAIN_VISUALIZATION_TASK_PRIORITY 0
#define PDS_VISUALIZATION_TASK_PRIORITY 0

#define DECODING_TASK_PRIORITY 0
#define POLLING_TASK_PRIORITY 0
#define STATE_MANAGER_TASK_PRIORITY 0

// task period
#define SAMPLING_TASK_PERIOD 0 // Period in ms
#define TRIGGER_TASK_PERIOD 0 // Period in ms
#define ANALYSIS_TASK_PERIOD 0 // Period in ms
#define TIME_DOMAIN_VISUALIZATION_TASK_PERIOD 0 // Period in ms
#define PDS_VISUALIZATION_TASK_PERIOD 0 // Period in ms
#define POLLING_TASK_PERIOD 0 // Period in ms

// task phases
#define SAMPLING_TASK_PHASE 0
#define TRIGGER_TASK_PHASE 0
#define ANALYSIS_TASK_PHASE 0
#define TIME_DOMAIN_VISUALIZATION_TASK_PHASE 0
#define PDS_VISUALIZATION_TASK_PHASE 0
#define POLLING_TASK_PHASE 0



// WCET for load simulation task
#define TRIGGER_WCET 1

/* These are values you probably don't need to change */
#define STACKSIZE    (CYGNUM_HAL_STACK_SIZE_MINIMUM+4096)

#define PDS_LENGTH 32
#define TIME_DOMAIN_LENGTH (2 * PDS_LENGTH)

#define SERIAL_IRQ CYGNUM_HAL_INTERRUPT_UART1

#define SERIAL_BUFFER_LENGTH 15

#define TRIGGER_LEVEL 188

#endif // CONFIG_H
